<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">

    <div class="row">

      <div class="col-md-12">


        <div class="row mb-2">

          <div class="col-md-4">
            <form action="">
              <div class="form-group row">
                <label for="cekdivisi" class="col-sm-4 col-form-label">Cek Divisi</label>
                <div class="col-sm-8">
                  <select name="cekdivisi" id="cekdivisi" class="form-control">
                    <option value="semua" selected>Tampilkan semua</option>
                    <option value="kb">KB</option>
                    <option value="ra">RA</option>
                    <option value="mi">MI</option>
                    <option value="mts">MTs</option>
                    <option value="ma">MA</option>
                  </select>
                </div>
              </div>
            </form>
          </div>

          <!-- Modal Tambah -->


          <!-- Modal Edit -->
          <div class="modal fade" id="editKelasModal" tabindex="-1" aria-labelledby="editKelasModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="editKelasModalLabel">Edit Kelas Aktif MIJ</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <form method="post" action="" id="editkelasform">
                    <?= csrf_field(); ?>
                    <input type="hidden" name="idkelas">

                    <div class="form-group row">
                      <label for="text" class="col-sm-2 col-form-label">Kelas</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="kelas" readonly>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="text" class="col-sm-2 col-form-label">Divisi</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="divisi" readonly>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="text" class="col-sm-2 col-form-label"></label>
                      <div class="col-sm-10">
                        <div class="form-check">
                          <input class="form-check-input editaktif" type="checkbox" name="aktif">
                          <label class="form-check-label" for="defaultCheck1">
                            Aktif?
                          </label>
                        </div>
                        <!-- <input type="text" class="form-control" name="aktif"> -->
                      </div>
                    </div>


                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="btnedit">Update</button>
                </div>
                </form>
              </div>
            </div>
          </div>

        </div>

        <div class="row">
          <div class="col">
            <div class="table-responsive">
              <table class="table table-striped table-condensed" id="tabelKelas">
                <thead class="bg-success">
                  <tr>
                    <!-- <th><input type="checkbox" id='checkall'></th> -->
                    <th scope="col">No</th>
                    <th scope="col">Kelas</th>
                    <th scope="col">divisi</th>
                    <th scope="col">sort</th>
                    <th scope="col">Aktif</th>
                    <th scope="col">Action</th>
                  </tr>
                </thead>

              </table>
            </div>
          </div>
        </div>

        <div class="overlay asal-divisi-overlay" style="display: none;">
          <!-- <i class="fas fa-sync fa-spin"></i> -->
          <div id='loading-img'></div>
        </div>



      </div>
    </div>



  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
  $(document).ready(function() {

    function tabelkelas(dataks) {
      let i = 1;
      let base = '<?= base_url(); ?>'
      $('#tabelKelas').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
          extend: 'excelHtml5',
          text: '<i class="far fa-fw fa-file-excel"></i>',
          titleAttr: 'Excel'
        }],
        "columnDefs": [{
          "className": "text-center",
          "targets": "_all"
        }],

        "columns": [

          {
            "data": null,
            "render": function() {

              return a = i++;
            }
          },

          {
            "data": "kelas",
          },
          {
            "data": "divisi",
            "render": function(data, type, row, meta) {
              let a = '';

              a = `${row.divisi}`

              return a.toUpperCase();
            }
          },
          {
            "data": "sort"
          },
          {
            "data": "aktif",
            "render": function(data, type, row, meta) {
              let a = '';

              if (data == 1) {
                a = 'aktif'
              } else {
                a = 'Tidak aktif'
              }


              return a;
            }
          },
          {
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                                    
                                    <a href="" value="${row.id}" class="badge badge-info editkelas"><i class="fas fa-fw fa-edit"></i></a>

                                    `

              return a;
            }
          },
        ]
      });
    }

    //fetch Kelas semua
    function fetchKelas() {
      $('.asal-divisi-overlay').show();
      $.ajax({
        url: '<?= base_url(); ?>/kelas/fetchkelas',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data.pegawai);
          // let i = 1;
          tabelkelas(data.kelas)
        }
      });
      $('.asal-divisi-overlay').hide();
    }

    fetchKelas();

    $("#cekdivisi").change(function() {
      let cekdivisi = $("#cekdivisi").val();
      // alert(divisiasal)
      if (cekdivisi == 'semua') {
        $('#tabelKelas').DataTable().clear();
        $('#tabelKelas').DataTable().destroy();
        fetchKelas();
      } else {
        $('.asal-divisi-overlay').show();
        $('#tabelKelas').DataTable().clear();
        $('#tabelKelas').DataTable().destroy();
        $.ajax({
          url: "<?= base_url(); ?>/kelas/fetchkelasdivisi",
          type: "post",
          data: {
            cekdivisi: cekdivisi
          },
          async: true,
          dataType: "json",

          success: function(data) {
            // console.log(data.satuan)
            if (data.responce == 'success') {
              // console.log(data.responce)
              tabelkelas(data.kelas)
            } else {
              // console.log(data.responce)
              tabelkelas(data.kelas)
            }
          }
        });


        $('.asal-divisi-overlay').hide();
      }
    })


    // modal edit
    $(document).on("click", ".editkelas", function() {
      event.preventDefault();

      let idkelas = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/kelas/editkelasmodal'); ?>',
        type: 'post',
        data: {
          idkelas: idkelas
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            // console.log(data.alur.aktif)
            $('#editKelasModal').modal('show');
            $("input[name='idkelas']").val(data.kelas.id);
            $("input[name='kelas']").val(data.kelas.kelas);
            $("input[name='divisi']").val(data.kelas.divisi);


            if (data.kelas.aktif == 1) {
              $("input[name='aktif']").attr("checked", "checked");
            }

          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    $("#editkelasform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/kelas/editkelas',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnedit').attr('disabled');
          $("#btnedit").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editKelasModal').modal('hide');
            $('#tabelKelas').DataTable().destroy();
            fetchKelas();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }

        },
        complete: function() {
          $('#btnedit').removeAttr('disabled');
          $("#btnedit").html(`Update`);

        },

      });
    })

  })
</script>

<?= $this->endSection(); ?>