<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">


        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">


                    <div class="col-md-5">
                        <form action="">
                            <div class="form-group row">
                                <label for="cekva" class="col-sm-5 col-form-label">Cek Status Pembayaran</label>
                                <div class="col-sm-7">
                                    <select name="cekva" id="cekva" class="form-control">
                                        <option value="semua" selected>Tampilkan semua</option>
                                        <option value="sudah">Sudah pembayaran </option>
                                        <option value="belum">Belum pembayaran</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="col-md-7">
                        <button type="button" id="btntambahcapesmodal" class="btn btn-primary" data-toggle="modal" data-target="#tambahCapesModal">
                            Tambah
                        </button>
                        <button type="button" class="btn btn-danger" name="btndeletecapes" id="btndeletecapes">
                            Hapus
                        </button>

                        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#importModal">
                            Import
                        </button>
                        <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#updatevaModal">
                            Update
                        </button>
                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahCapesModal" tabindex="-1" aria-labelledby="tambahCapesModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahCapesModalLabel">Tambah Calon Peserta Didik</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahcapesform">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="no_va" class="col-sm-3 col-form-label">No.Pembayaran</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="no_va">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nik" class="col-sm-3 col-form-label">NIK</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nik">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nisn" class="col-sm-3 col-form-label">NISN</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nisn">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nama_lengkap" class="col-sm-3 col-form-label">Nama</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nama_lengkap">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email" class="col-sm-3 col-form-label">Email</label>
                                            <div class="col-sm-9">
                                                <input type="email" class="form-control" name="email">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email" class="col-sm-3 col-form-label">Kelas</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="kelas">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="divisi" class="col-sm-3 col-form-label">Divisi</label>
                                            <div class="col-sm-9">

                                                <select name="divisi" id="divisi" class="form-control">
                                                    <option disabled selected>Tampilkan semua</option>
                                                    <option value="KB">KB</option>
                                                    <option value="RA">RA</option>
                                                    <option value="MI">MI</option>
                                                    <option value="MTS">MTS</option>
                                                    <option value="MA">MA</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="no_reg" class="col-sm-3 col-form-label">No.Reg</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="no_reg">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="status_pembayaran" class="col-sm-3 col-form-label">Status</label>
                                            <div class="col-sm-9">
                                                <select name="status_pembayaran" id="status_pembayaran" class="form-control">
                                                    <option disabled selected>Tampilkan semua</option>
                                                    <option value="belum">Belum</option>
                                                    <option value="sudah">Sudah</option>
                                                </select>
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btntambahcapes">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editCapesModal" tabindex="-1" aria-labelledby="editCapesModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editCapesModalLabel">Edit Calon Peserta Didik</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editcapesform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="idcapes">
                                        <div class="form-group row">
                                            <label for="no_va" class="col-sm-3 col-form-label">No.Pembayaran</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="no_va">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nik" class="col-sm-3 col-form-label">NIK</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nik">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nisn" class="col-sm-3 col-form-label">NISN</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nisn">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nama_lengkap" class="col-sm-3 col-form-label">Nama</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="nama_lengkap">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email" class="col-sm-3 col-form-label">Email</label>
                                            <div class="col-sm-9">
                                                <input type="email" class="form-control" name="email">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="kelas" class="col-sm-3 col-form-label">Kelas</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="kelas">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="divisi" class="col-sm-3 col-form-label">Divisi</label>
                                            <div class="col-sm-9">
                                                <select name="divisi" id="editdivisi" class="form-control">

                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="no_reg" class="col-sm-3 col-form-label">No.Reg</label>
                                            <div class="col-sm-9">
                                                <input type="text" class="form-control" name="no_reg">
                                            </div>
                                        </div>


                                        <div class="form-group row">
                                            <label for="status_pembayaran" class="col-sm-3 col-form-label">Status</label>
                                            <div class="col-sm-9">
                                                <select name="status_pembayaran" id="editstatus_pembayaran" class="form-control">

                                                </select>
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btneditcapes">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- modal import -->
                    <div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="importModalLabel">Import Data Calon Peserta Didik</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <!-- Form Tambah Data -->
                                    <form action="" method="POST" id="importcapes" enctype="multipart/form-data">
                                        <div class="form_group" style="margin-bottom: 5;">
                                            <label for="">Unggah File</label>
                                            <input type="file" id="filecapes" name="filecapes" class="form-control">
                                        </div>
                                        <br>
                                        <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_capes.xls">Download Template Import Calon Peserta Didik</a></p>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnimportcapes">Import</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- modal import update -->
                    <div class="modal fade" id="updatevaModal" tabindex="-1" aria-labelledby="updatevaModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="updatevaModalLabel">Import VA Calon Peserta Didik</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <!-- Form Tambah Data -->
                                    <form action="" method="POST" id="importva" enctype="multipart/form-data">
                                        <div class="form_group" style="margin-bottom: 5;">
                                            <label for="">Unggah File</label>
                                            <input type="file" id="fileva" name="fileva" class="form-control">
                                        </div>
                                        <br>
                                        <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_va.xls">Download Template Import VA Calon Peserta Didik</a></p>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnupdatecapes">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelCapes">
                                <thead class="bg-success">
                                    <tr>
                                        <th><input type="checkbox" id='checkall'></th>
                                        <!-- <th scope="col">No</th> -->
                                        <th scope="col">No. Pembayaran</th>
                                        <th scope="col">NIK</th>
                                        <th scope="col">NISN</th>
                                        <th scope="col">Nama Lengkap</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Kelas</th>
                                        <th scope="col">Divisi</th>
                                        <th scope="col">No Registrasi</th>
                                        <th scope="col">Status Pembayaran</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
    $(document).ready(function() {

        function tabelcapes(dataks) {
            $('#tabelCapes').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        targets: 0,
                        data: null,
                        className: 'text-center',
                        searchable: false,
                        orderable: false,

                        "render": function(data, type, row, meta) {
                            var r =
                                '<input type="checkbox" name="checkbox" id = "' + row.id + '"  value = "' + row.id + '" class="select_checkbox"></input>';

                            return r;
                        },
                    },

                    {
                        "data": "no_va"
                    },
                    {
                        "data": "nik"
                    },
                    {
                        "data": "nisn"
                    },
                    {
                        "data": "nama_lengkap"
                    },
                    {
                        "data": "email"
                    },
                    {
                        "data": "kelas"
                    },
                    {
                        "data": "divisi"
                    },
                    {
                        "data": "no_reg"
                    },
                    {

                        "data": 'status_pembayaran',

                        "render": function(data, type, row, meta) {


                            let a = '';
                            if (data == 'belum') {
                                a = `<span class="badge badge-danger">` + data + `</span>`
                            } else {
                                a = `<span class="badge badge-success">` + data + `</span>`
                            }
                            return a
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                    <a href="" value="${row.id}" class="badge badge-info editcapes"><i class="fas fa-fw fa-edit"></i></a>`

                            return a;
                        }
                    },
                ]
            });
        }

        //fetch capes VA belum
        function fetchCapesBelum() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/capes/fetchcapesbelum',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);

                    $('#tabelCapes').DataTable().clear();
                    $('#tabelCapes').DataTable().destroy();
                    tabelcapes(data.capes)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        //fetch capes VA sudah
        function fetchCapesSudah() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/capes/fetchcapessudah',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    $('#tabelCapes').DataTable().clear();
                    $('#tabelCapes').DataTable().destroy();
                    tabelcapes(data.capes)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        //fetch Capes semua
        function fetchCapesSemua() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/capes/fetchcapessemua',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    $('#tabelCapes').DataTable().destroy();
                    tabelcapes(data.capes)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchCapesSemua();
        // fetchCapesSudah();

        $("#cekva").change(function() {
            let cekva = $("#cekva").val();
            // alert(divisiasal)
            if (cekva == 'semua') {
                fetchCapesSemua();
            } else if (cekva == 'belum') {
                fetchCapesBelum();
            } else {
                fetchCapesSudah();
            }
        })

        $(document).on("click", "#btntambahcapesmodal", function() {
            $('#tambahcapesform')[0].reset();
        })

        // save capes
        $('#tambahcapesform').submit(function() {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url('/capes/savecapes'); ?>',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                // data: $(this).serialize(),
                beforeSend: function() {
                    // setting a timeout
                    $('#btntambahcapes').attr('disabled');
                    $("#btntambahcapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahCapesModal').modal('hide');
                        $('#tabelCapes').DataTable().destroy();
                        fetchCapesSemua();
                        toastr["success"](data.pesan);

                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btntambahcapes').removeAttr('disabled');
                    $("#btntambahcapes").html(`Simpan`);

                },
            });

        });

        // modal edit
        $(document).on("click", ".editcapes", function() {
            event.preventDefault();
            $("#editstatus_pembayaran").children().remove();
            $("#editdivisi").children().remove();
            let idcapes = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/capes/editmodal'); ?>',
                type: 'post',
                data: {
                    idcapes: idcapes
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        $('#editCapesModal').modal('show');
                        $("input[name='idcapes']").val(data.capes.id);
                        $("input[name='no_reg']").val(data.capes.no_reg);
                        $("input[name='nik']").val(data.capes.nik);
                        $("input[name='nisn']").val(data.capes.nisn);
                        $("input[name='nama_lengkap']").val(data.capes.nama_lengkap);
                        $("input[name='email']").val(data.capes.email);
                        $("input[name='kelas']").val(data.capes.kelas);

                        $("#editdivisi").append('<option disabled selected>Tampilkan semua</option>');
                        $("#editdivisi").append('<option value="KB"' + ((data.capes.divisi == 'KB') ? 'selected="selected"' : '') + '>KB</option>');
                        $("#editdivisi").append('<option value="RA"' + ((data.capes.divisi == 'RA') ? 'selected="selected"' : '') + '>RA</option>');
                        $("#editdivisi").append('<option value="MI"' + ((data.capes.divisi == 'MI') ? 'selected="selected"' : '') + '>MI</option>');
                        $("#editdivisi").append('<option value="MTS"' + ((data.capes.divisi == 'MTS') ? 'selected="selected"' : '') + '>MTS</option>');
                        $("#editdivisi").append('<option value="MA"' + ((data.capes.divisi == 'MA') ? 'selected="selected"' : '') + '>MA</option>');

                        $("input[name='no_va']").val(data.capes.no_va);


                        $("#editstatus_pembayaran").append('<option disabled selected>Tampilkan semua</option>');
                        $("#editstatus_pembayaran").append('<option value="belum"' + ((data.capes.status_pembayaran == 'belum') ? 'selected="selected"' : '') + '>belum</option>');
                        $("#editstatus_pembayaran").append('<option value="sudah"' + ((data.capes.status_pembayaran == 'sudah') ? 'selected="selected"' : '') + '>sudah</option>');

                    } else {

                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        // edit capes

        $("#editcapesform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/capes/editcapes',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    // setting a timeout
                    $('#btneditcapes').attr('disabled');
                    $("#btneditcapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editCapesModal').modal('hide');
                        $('#tabelCapes').DataTable().destroy();
                        fetchCapesSemua();
                        $('#tambahcapesform')[0].reset();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                },
                complete: function() {
                    $('#btneditcapes').removeAttr('disabled');
                    $("#btneditcapes").html(`Update`);
                },
            });
        })

        // import calon peserta
        $('#importcapes').submit(function() {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url('/capes/importcapes'); ?>',
                type: 'post',
                data: new FormData(this),
                dataType: 'json',
                cache: false,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    // setting a timeout
                    $('#btnimportcapes').attr('disabled');
                    $("#btnimportcapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tabelCapes').DataTable().destroy();
                        fetchCapesSemua();
                        $('#importModal').modal('hide');
                        toastr["success"](data.pesan);
                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btnimportcapes').removeAttr('disabled');
                    $("#btnimportcapes").html(`Import`);
                    $('#tambahcapesform')[0].reset();
                    $('#importcapes')[0].reset();
                },
            });

        });

        // import VA
        $('#importva').submit(function() {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url('/capes/importva'); ?>',
                type: 'post',
                data: new FormData(this),
                dataType: 'json',
                cache: false,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    // setting a timeout
                    $('#btnupdatecapes').attr('disabled');
                    $("#btnupdatecapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tabelCapes').DataTable().destroy();
                        fetchCapesSemua();
                        $('#updatevaModal').modal('hide');
                        toastr["success"](data.pesan);
                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btnupdatecapes').removeAttr('disabled');
                    $("#btnupdatecapes").html(`Update`);
                    $('#tambahcapesform')[0].reset();
                    $('#importva')[0].reset();
                },
            });

        });


        // Check all 
        $('#checkall').click(function() {
            if ($(this).is(':checked')) {
                $('.select_checkbox').prop('checked', true);
            } else {
                $('.select_checkbox').prop('checked', false);
            }
        });

        $('.select_checkbox').click(function() {
            if ($(this).is(':checked')) {
                $(this).closest('tr').addClass('removeRow');
            } else {
                $(this).closest('tr').removeClass('removeRow');
            }
        });

        // button delete
        $('#btndeletecapes').click(function() {
            let checkbox = $('.select_checkbox:checked');

            if (checkbox.length > 0) {
                Swal.fire({
                    title: 'Apa kamu yakin ingin menghapus ' + checkbox.length + ' calon peserta didik?',
                    text: "kamu tidak akan bisa mengembalikannya!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Ya, hapus saja!'
                }).then((result) => {
                    if (result.isConfirmed) {

                        let checkbox_value = [];
                        $(checkbox).each(function() {
                            checkbox_value.push($(this).val());
                        });

                        // console.log(checkbox);
                        $.ajax({
                            url: '<?= base_url('/capes/deletecapes'); ?>',
                            type: "POST",
                            data: {
                                checkbox_value: checkbox_value
                            },
                            dataType: 'json',
                            success: function(data) {
                                if (data.responce == "success") {
                                    Swal.fire(
                                        'Deleted!',
                                        'Data berhasil dihapus.',
                                        'success'
                                    )
                                    $('#tabelCapes').DataTable().destroy();
                                    fetchCapesSemua();
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops...',
                                        text: 'Ada yang tidak beres!',
                                    })
                                }
                            }
                        })

                    }
                })

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Pilih minimal satu data',
                })

            }
        });






    })
</script>

<?= $this->endSection(); ?>