<?php

namespace App\Controllers;

use App\Models\LoginModel;
use CodeIgniter\Controller;


class Login extends Controller
{
    protected $loginModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
    }

    public function index()
    {

        $data = [
            'title' => 'Login Admin PPDB',
            'validation' => \Config\Services::validation()
        ];

        return view('backend/login', $data);
    }

    public function ceklogin()
    {
        if (!$this->validate([
            'username' => [
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Username tidak boleh kosong.'
                ]
            ],
            'password'    => [
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Password tidak boleh kosong.'
                ]
            ],
        ])) {

            $validation =  \Config\Services::validation();
            $valid = [
                'username' => $validation->getError('username'),
                'password' => $validation->getError('password'),
            ];
            $data = [
                'success' => false,
                'validation' => $valid
            ];
        } else {
            // validasi sukses
            $username = $this->request->getVar('username');
            $password = $this->request->getVar('password');

            $ceklog = $this->loginModel->where('username', $username)->findAll();
            $ceklogcount = $this->loginModel->where('username', $username)->countAllResults();
            // dd($ceklog);

            if ($ceklogcount < 1) {
                $data = [
                    'success' => true,
                    'responce' => 'not',
                    'ceklog' => $ceklog
                ];
            } else {
                if (password_verify($password, $ceklog[0]['password'])) {
                    // if ($password == $ceklog[0]['password']) {
                    $data = [
                        'success' => true,
                        'responce' => 'yes',
                        'ceklog' => $ceklog
                    ];
                    $user = [
                        'id' => $ceklog[0]['id'],
                        'username' => $ceklog[0]['username'],
                        'password' => $ceklog[0]['password'],
                        'nama' => $ceklog[0]['nama'],
                        'level' => $ceklog[0]['level']
                    ];
                    session()->set($user);
                } else {
                    $data = [
                        'success' => true,
                        'responce' => 'not',
                        'ceklog' => $ceklog
                    ];
                }
            }
        }

        return json_encode($data);
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('login'));
    }
}
