<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\JadwalModel;
use App\Models\BerkasModel;
use App\Models\DownloadModel;
use CodeIgniter\Controller;


class Berkas extends Controller
{

    protected $loginModel;
    protected $capesModel;
    protected $userModel;
    protected $jadwalModel;
    protected $berkasModel;
    protected $downloadModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->userModel = new UserModel();
        $this->jadwalModel = new JadwalModel();
        $this->berkasModel = new BerkasModel();
        $this->downloadModel = new DownloadModel();
    }

    public function index()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Pemberkasan',
            'user' => $cekuser
        ];

        return view('backend/berkas', $data);
    }

    public function fetchberkassemua()
    {
        if ($this->request->isAJAX()) {
            if ($berkas = $this->berkasModel->getBerkas()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'berkas' => $berkas
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function fetchberkasdivisi()
    {
        if ($this->request->isAJAX()) {
            $cekdivisi = $this->request->getVar('cekdivisi');
            if ($berkas = $this->berkasModel->getBerkasDivisi($cekdivisi)) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'berkas' => $berkas
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }


    public function deleteberkas($id)
    {
        if ($this->request->isAJAX()) {

            $file = $this->berkasModel->where('id', $id)->get()->getRowArray();

            //hapus gambar lama
            unlink('asset/berkas/' . $file['file']);
            $this->berkasModel->where('id', $id)->delete();
        } else {
            echo "No direct script access allowed";
        }
    }

    public function filedownload()
    {
        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Form Download',
            'user' => $cekuser
        ];

        return view('backend/filedownload', $data);
    }

    public function fetchdownload()
    {
        if ($this->request->isAJAX()) {

            if ($download = $this->downloadModel->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'download' => $download
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch download'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function savedownload()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'judul' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Judul tidak boleh kosong'
                    ]
                ],
                'url' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Url tidak boleh kosong'

                    ]
                ],


                'sort' => [
                    'rules' => 'required|numeric',
                    'errors' => [
                        'required' => 'Sort harus dipilih',
                        'numeric' => 'sort harus angka'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses



                $insert = $this->request->getVar();


                $this->downloadModel->insert($insert);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'Download berhasil ditambah'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editdownloadmodal()
    {
        if ($this->request->isAJAX()) {
            $iddownload = $this->request->getVar('iddownload');
            if ($download = $this->downloadModel->where('id', $iddownload)->get()->getRowArray()) {
                $data = [
                    'responce' => 'success',
                    'download' => $download
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal memunculkan modal edit data'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editdownload()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'judul' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Judul tidak boleh kosong'
                    ]
                ],
                'url' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Url tidak boleh kosong'

                    ]
                ],
                'sort' => [
                    'rules' => 'required|numeric',
                    'errors' => [
                        'required' => 'Sort harus dipilih',
                        'numeric' => 'sort harus angka'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                $iddownload = $this->request->getVar('iddownload');
                $judul = $this->request->getVar('judul');
                $url = $this->request->getVar('url');
                $sort = $this->request->getVar('sort');

                $update = [
                    'judul' => $judul,
                    'url' => $url,
                    'sort' => $sort
                ];


                $this->downloadModel->update($iddownload, $update);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'Data berhasil diupdate'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function deletedownload($id)
    {
        if ($this->request->isAJAX()) {
            $this->downloadModel->where('id', $id)->delete();
            // $this->menuModel->where('id', $id)->delete();
        } else {
            echo "No direct script access allowed";
        }
    }
}
