<?php

namespace App\Controllers\backend;

use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use CodeIgniter\Controller;


class Dashboard extends Controller
{
    protected $loginModel;
    protected $capesModel;
    protected $userModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->userModel = new UserModel();
    }

    public function index()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $jumlahcapes = $this->capesModel->countAll();
        $jumlahlunas = $this->capesModel->where('status_pembayaran', 'sudah')->countAllResults();
        $jumlahuser = $this->userModel->countAll();
        // dd($submenu);

        $data = [
            'title' => 'Dashboard',
            'user' => $cekuser,
            'jumlahcapes' => $jumlahcapes,
            'jumlahlunas' => $jumlahlunas,
            'jumlahuser' => $jumlahuser
        ];

        return view('backend/dashboard', $data);
    }
}
