<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">

        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">
                    <div class="col-md-8">
                        <button type="button" id="btntambahbiaya" class="btn btn-primary" data-toggle="modal" data-target="#tambahBiayaModal">
                            Tambah
                        </button>

                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahBiayaModal" tabindex="-1" aria-labelledby="tambahBiayaModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahBiayaModalLabel">Tambah Biaya PPDB MIJ</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahbiayaform" enctype="multipart/form-data">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="biaya" class="col-sm-2 col-form-label">Biaya</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="text" class="form-control" name="alur"> -->
                                                <input type="file" class="form-control custom-file-input" id="foto" name="foto" onchange="previewImg()">
                                                <label class="custom-file-label" for="foto"></label>
                                                <div class="col-sm-12">
                                                    <img src="" class="img-thumbnail img-preview">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="aktif" checked='checked'>
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Aktif?
                                                    </label>
                                                </div>
                                                <!-- <input type="text" class="form-control" name="aktif"> -->
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnsimpan">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editBiayaModal" tabindex="-1" aria-labelledby="editBiayaModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editBiayaModalLabel">Edit Biaya PPDB MIJ</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editbiayaform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="idbiaya">

                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="form-check">
                                                    <input class="form-check-input editaktif" type="checkbox" name="aktif">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Aktif?
                                                    </label>
                                                </div>
                                                <!-- <input type="text" class="form-control" name="aktif"> -->
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnedit">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelBiaya">
                                <thead class="bg-success">
                                    <tr>
                                        <!-- <th><input type="checkbox" id='checkall'></th> -->
                                        <th scope="col">No</th>
                                        <th scope="col">Biaya</th>
                                        <th scope="col">sort</th>
                                        <th scope="col">Aktif</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->
<script>
    function previewImg() {
        let foto = document.querySelector('#foto');
        let fotoLabel = document.querySelector('.custom-file-label');
        let imgPreview = document.querySelector('.img-preview');

        fotoLabel.textContent = foto.files[0].name;

        let fileFoto = new FileReader();
        fileFoto.readAsDataURL(foto.files[0]);

        fileFoto.onload = function(e) {
            imgPreview.src = e.target.result;
        }
    }
</script>

<script>
    $(document).ready(function() {

        function tabelbiaya(dataks) {
            let i = 1;
            let base = '<?= base_url(); ?>'
            $('#tabelBiaya').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "biaya",
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `<img src="` + base + `/asset/images/biaya/` + data + `"  alt="..." width=200>`

                            return a;
                        }
                    },
                    {
                        "data": "sort"
                    },
                    {
                        "data": "aktif",
                        "render": function(data, type, row, meta) {
                            let a = '';

                            if (data == 1) {
                                a = 'aktif'
                            } else {
                                a = 'Tidak aktif'
                            }


                            return a;
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                    
                                    <a href="" value="${row.id}" class="badge badge-info editbiaya"><i class="fas fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletebiaya"><i class="fas fa-fw fa-trash"></i></a>

                                    `

                            return a;
                        }
                    },
                ]
            });
        }

        //fetch Biaya semua
        function fetchBiaya() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/biaya/fetchbiaya',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    // let i = 1;
                    tabelbiaya(data.biaya)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchBiaya();

        $(document).on('click', '#btntambahbiaya', function() {
            $('#tambahbiayaform')[0].reset();
        })

        // tambah biaya
        $("#tambahbiayaform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/biaya/tambahbiaya',
                type: 'post',
                data: new FormData(this),
                dataType: 'json',
                cache: false,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    // setting a timeout
                    $('#btnsimpan').attr('disabled');
                    $("#btnsimpan").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahBiayaModal').modal('hide');
                        $('#tabelBiaya').DataTable().clear();
                        $('#tabelBiaya').DataTable().destroy();
                        fetchBiaya();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                        // console.log(data);
                    }
                },
                complete: function() {
                    $('#btnsimpan').removeAttr('disabled');
                    $("#btnsimpan").html(`Simpan`);

                },
            });
        });

        // delete biaya
        $(document).on("click", ".deletebiaya", function() {
            event.preventDefault();
            let idbiaya = $(this).attr('value');

            Swal.fire({
                title: 'Apa kamu yakin untuk menghapusnya?',
                text: "kamu tidak akan bisa mengembalikannya",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus saja!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?= base_url('/biaya/deletebiaya'); ?>/' + idbiaya,
                        type: 'DELETE',
                        error: function() {
                            alert('Something is wrong');
                        },
                        success: function(data) {
                            $('#tabelBiaya').DataTable().destroy();
                            fetchBiaya();
                            Swal.fire(
                                'Deleted!',
                                'Biaya sudah terdelete.',
                                'success'
                            )
                        }
                    });

                }
            })
        });

        // modal edit
        $(document).on("click", ".editbiaya", function() {
            event.preventDefault();

            let idbiaya = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/biaya/editbiayamodal'); ?>',
                type: 'post',
                data: {
                    idbiaya: idbiaya
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        // console.log(data.alur.aktif)
                        $('#editBiayaModal').modal('show');
                        $("input[name='idbiaya']").val(data.biaya.id);
                        $("input[name='sort']").val(data.biaya.sort);


                        if (data.biaya.aktif == 1) {
                            $("input[name='aktif']").attr("checked", "checked");
                        }

                    } else {

                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        $("#editbiayaform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/biaya/editbiaya',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    // setting a timeout
                    $('#btnedit').attr('disabled');
                    $("#btnedit").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editBiayaModal').modal('hide');
                        $('#tabelBiaya').DataTable().destroy();
                        fetchBiaya();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                },
                complete: function() {
                    $('#btnedit').removeAttr('disabled');
                    $("#btnedit").html(`Update`);

                },

            });
        })

    })
</script>

<?= $this->endSection(); ?>