<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <meta name="description" content="Aplikasi Absensi pegawai MIJ" />
  <meta name="keywords" content="" />
  <!-- agar tidak indeks searc engine -->
  <meta name="robots" content="noindex,nofollow" />
  <meta name="google-site-verification" content="K_QozFevcTRvp1e5DByvpct7aIcPG7I0y9DTr3yquE4" />


  <link href="<?= base_url('assets/bootstrap/dist/css/bootstrap.min.css'); ?>" rel="stylesheet">
  <!-- <link href="https://raw.githubusercontent.com/samrayner/bootstrap-side-navbar/gh-pages/assets/stylesheets/navbar-fixed-side.css" rel="stylesheet" /> -->

  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.1.1/css/responsive.bootstrap.min.css">
  <link href="https://v4-alpha.getbootstrap.com/examples/dashboard/dashboard.css" rel="stylesheet" />
  <link href="https://v4-alpha.getbootstrap.com/examples/sticky-footer-navbar/sticky-footer-navbar.css" rel="stylesheet" />
  <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.bootstrap4.min.css" />
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />

  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.3.1/css/select.dataTables.min.css">

  <link rel="icon" href="<?= base_url('assets/icon/madrasah.png'); ?>">
  <title>Absensi Karyawan MIJ</title>


</head>

<body style="padding-top: 70px;">

  <nav class="navbar navbar-inverse navbar-fixed-top">
    <div class="container-fluid">
      <div class="navbar-header">

        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse" aria-expanded="false">
          <span class="sr-only">Toggle navigation</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        <a href="" class="navbar-brand">
          <img src="<?= base_url('assets/icon/madrasahicon.png'); ?>" alt="Brand" class="img-responsive img-circle" style="display:inline-block; margin-top:-5px; margin-right: 7px;">Absensi madrasah Istiqlal Jakarta
        </a>
      </div>

      <div class="collapse navbar-collapse" id="navbar-collapse">
        <ul class="nav navbar-nav">
          <?php if ($this->session->has_userdata('user_id')) : ?>
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Data absen <span class="caret"></span></a>
              <ul class="dropdown-menu">
                <li><a href="<?= site_url('data_absen'); ?>">Data absensi</a></li>
                <?php if ($this->session->userdata('user_status') === 'karyawan') : ?>
                  <?php if ($this->session->userdata('absen_masuk') === TRUE) : ?>
                    <li><a href="<?= site_url('absen_pulang'); ?>">Absen pulang</a></li>
                  <?php elseif ($this->session->userdata('absen_masuk') === FALSE) : ?>
                    <li><a href="<?= site_url('absen'); ?>">Absen masuk</a></li>
                  <?php elseif ($this->session->userdata('absen_pulang') === TRUE) : ?>

                  <?php endif; ?>
                <?php endif; ?>
              </ul>
            </li>

            <?php if ($this->session->userdata('user_status') === 'admin') : ?>
              <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Data karyawan <span class="caret"></span></a>
                <ul class="dropdown-menu">
                  <li><a href="<?= site_url('data_karyawan'); ?>">Data karyawan</a></li>
                  <li><a href="<?= site_url('input_karyawan'); ?>">Tambah data karyawan</a></li>
                </ul>
              </li>
            <?php endif; ?>
          <?php endif; ?>
        </ul>

        <ul class="nav navbar-nav navbar-right hidden-md hidden-lg">
          <li class="dropdown">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Akun <span class="caret"></span></a>
            <ul class="dropdown-menu">

              <?php if ($this->session->has_userdata('logged_in')) : ?>
                <?php if ($this->session->userdata('user_status') === 'admin') : ?>
                  <li><a href="<?= site_url('admin/profile'); ?>">Profile</a></li>
                <?php else : ?>
                  <li><a href="<?= site_url('profile'); ?>">Profile</a></li>
                <?php endif; ?>
              <?php endif; ?>

              <li role="separator" class="divider"></li>

              <?php if ($this->session->has_userdata('logged_in')) : ?>
                <li><a href="<?= site_url('logout'); ?>">Logout</a></li>
              <?php else : ?>
                <li><a href="<?= site_url('login'); ?>">Login</a></li>
                <li><a href="<?= site_url('login_admin'); ?>">Login Admin</a></li>
              <?php endif; ?>

            </ul>
          </li>
        </ul>

        <?php if ($this->session->has_userdata('logged_in')) : ?>
          <ul class="nav navbar-nav navbar-right">
            <li class="active"><a href="#">
                <?= strtoupper($this->session->userdata('username') . ' || ' . $this->session->userdata('user_status')); ?>
              </a></li>
          </ul>
        <?php endif; ?>

      </div>

    </div>
  </nav>

  <div class="container-fluid">
    <div class="row">
      <nav class="col-sm-3 col-md-2 hidden-sm hidden-xs sidebar" style="background-color: #f7f7f7;">
        <ul class="nav nav-pills flex-column">
          <?php if ($this->session->has_userdata('user_id')) : ?>
            <?php if ($this->session->userdata('user_status') === 'admin') : ?>
              <li class="nav-item">
                <a class="nav-link" href="<?= site_url('admin/profile'); ?>">
                  <span class="glyphicon glyphicon-user" aria-hidden="true"></span>
                  Profile
                </a>
              </li>
            <?php else : ?>
              <li class="nav-item">
                <a class="nav-link" href="<?= site_url('profile'); ?>">
                  <span class="glyphicon glyphicon-user" aria-hidden="true"></span>
                  Profile
                </a>
              </li>
            <?php endif; ?>

            <li class="nav-item" style="height: 1px; margin: 9px 0; overflow: hidden; background-color: #e5e5e5;"></li>

            <li class="nav-item">
              <a href="<?= site_url('logout'); ?>" class="nav-link">
                <span class="glyphicon glyphicon-log-out" aria-hidden="true"></span>
                Logout
              </a>
            </li>
          <?php else : ?>
            <li class="nav-item">
              <a href="<?= site_url('login'); ?>" class="nav-link">
                <span class="glyphicon glyphicon-log-in" aria-hidden="true"></span>
                Login
              </a>
              <a href="<?= site_url('login_admin'); ?>" class="nav-link">
                <span class="glyphicon glyphicon-log-in" aria-hidden="true"></span>
                Login Admin
              </a>
            </li>
          <?php endif; ?>
        </ul>
      </nav>

      <main class="col-sm-12 col-md-10 col-md-offset-2 pt-3">