<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
  require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Frontend::login');
$routes->post('/cekloginsiswa', 'Frontend::ceklogin');
$routes->get('/homesiswa', 'Frontend::home', ['filter' => 'aksessiswa']);
$routes->get('/lihatskl/(:num)', 'Frontend::lihatskl/$1', ['filter' => 'aksessiswa']);
$routes->get('/logoutsiswa', 'Frontend::logout');

//Login page
$routes->get('/loginadmin', 'Admin::login');
$routes->post('/ceklogin', 'Admin::ceklogin');
$routes->get('/adminlogout', 'Admin::logout');

//admin page
$routes->get('/admin', 'Admin::home', ['filter' => 'aksesadmin']);
$routes->get('/homeadmin', 'Admin::home', ['filter' => 'aksesadmin']);

//user page admin
$routes->get('/user', 'User::index', ['filter' => 'aksesadmin']);
$routes->post('/user/fetchuser', 'User::fetchuser', ['filter' => 'aksesadmin']);
$routes->post('/user/saveuser', 'User::saveuser', ['filter' => 'aksesadmin']);
$routes->post('/user/editmodal', 'User::editmodal', ['filter' => 'aksesadmin']);
$routes->post('/user/edituser', 'User::edituser', ['filter' => 'aksesadmin']);
$routes->post('/user/editpassword', 'User::editpassword', ['filter' => 'aksesadmin']);
$routes->delete('/user/deleteuser/(:num)', 'User::deleteuser/$1', ['filter' => 'aksesadmin']);

//setting page admin
$routes->get('/setting', 'Setting::index', ['filter' => 'aksesadmin']);
$routes->post('/setting/edit', 'Setting::edit', ['filter' => 'aksesadmin']);

//siswa page admin
$routes->get('/siswa', 'Siswa::index', ['filter' => 'aksesadmin']);
$routes->post('/siswa/fetchsiswa', 'Siswa::fetchsiswa', ['filter' => 'aksesadmin']);
$routes->post('/siswa/savesiswa', 'Siswa::savesiswa', ['filter' => 'aksesadmin']);
$routes->post('/siswa/editpassword', 'Siswa::editpassword', ['filter' => 'aksesadmin']);
$routes->post('/siswa/editmodal', 'Siswa::editmodal', ['filter' => 'aksesadmin']);
$routes->post('/siswa/editsiswa', 'Siswa::editsiswa', ['filter' => 'aksesadmin']);
$routes->post('/siswa/deletesiswa', 'Siswa::deletesiswa', ['filter' => 'aksesadmin']);
$routes->post('/siswa/sinkronskl', 'Siswa::sinkronskl', ['filter' => 'aksesadmin']);
$routes->post('/siswa/importsiswa', 'Siswa::importsiswa', ['filter' => 'aksesadmin']);

$routes->get('/siswa/bacaskl/(:num)', 'Siswa::bacaskl/$1', ['filter' => 'aksesadmin']);


//file skl page admin
$routes->get('/fileskl', 'Fileskl::index', ['filter' => 'aksesadmin']);
$routes->get('/fileskl/download/(:num)', 'Fileskl::download/$1', ['filter' => 'aksesadmin']);
$routes->delete('/fileskl/deletefile/(:any)', 'Fileskl::deletefile/$1', ['filter' => 'aksesadmin']);
$routes->post('/fileskl/addfile', 'Fileskl::addfile', ['filter' => 'aksesadmin']);

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
  require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
